<?php
/***************************************
Descending Explorer
By: Justin Pearce
Website: http://www.guardianfox.net
The purpose of this script is to provide the ability for a webmaster to post files to a folder
and not need a complex interface for displaying them. Granted, one could just go for the default
Apache directory listing. However, there are some concerns with showing everything, especially when
one does not have total control over the server. 
***************************************/
/*Version History:

08/27/2006 - Descending Explorer first created!

04/27/2008 - Updated the scripting to use the linux 'ls' command with options to better list files
             with newest on top, as opposed to by file name. Also the display is updated to paginate
             file display to cut back on resources used by the script.

11/15/2009 - Updated to add custom labeling and clean up some of the commentary

*/

/* Scotty, more power! ... I'm givin' her all she's got, Captain!!*/
/* This can be commented out, if not needed */
ini_set('memory_limit', '256M');

//[Configuration]///////////////////////
GLOBAL $filesperpage, $folderslabel, $fileslabel;

/*Height: This specifies the height of the generated thumbnails for images in pixles.
          Obviously, a smaller number meants smaller thumbnails, which saves load time.*/
$height="75";

/*StartDIR: This specifies the 'root' of the directory tree this script decends.
            Default is the current folder the script resides in.*/
$startDIR=".";

/*Disallowed: This specifies a list of file extensions that are not allowed to be displayed
              Default is the most common PHP extensions.*/
$disallowed="php, php4, php5, phps";

/*These are various colors use in the page of the script*/
$link="#000000";
$active="#000000";
$visited="#C5C5C5";
$hover="#FFFFFF";
$althover="#000000";
$background="#FFFFFF";
/*Font height variable used in display.*/
$fontheight="14";
/*Folders Label: This will be the label above the list of subfolders*/
$folderslabel="Folders:<br>";
/*Files Label: This will be the label above the list of files.*/
$fileslabel="Files:<br><hr>";
/*Page Title: This is pretty self explanitory*/
$pagetitle="Descending Explorer";
/*Files per page: Number of files to show on a given page. Default: 25*/
$filesperpage=25;
/*Max Columns: Number of columns to list files in. Default: 3*/
$maxcolumns=3;
////////////////////////////////////////

if(isset($_GET['file']))
{
    sizeImage($_GET['file'], $_GET['t'], $height);
    exit;
}
else
{
    $linkpad=($height/2)-$fontheight;
    echo '<html>'."\n";
    echo '<title>'.$pagetitle.'</title>'."\n";
    echo '<style type="text/css">'."\n";
    echo '<!--'."\n";
    echo 'a:link {color: '.$link.'; background: '.$background.'; text-decoration: none; font-height: '.$fontheight.'px;}'."\n";
    echo 'a:active {color: '.$active.'; background: '.$background.'; text-decoration: none; font-height: '.$fontheight.'px;}'."\n";
    echo 'a:visited {color: '.$visited.'; background: '.$background.'; text-decoration: none; font-height: '.$fontheight.'px;}'."\n";
    echo 'a:hover {color: '.$hover.'; background: '.$althover.'; text-decoration: underline; font-height: '.$fontheight.'px;}'."\n";
    echo '-->'."\n";
    echo '</style>'."\n";
    echo '<body bgcolor="'.$background.'">'."\n";
    if(isset($_GET['SSID']))
     $directory=base64_decode($_GET['SSID']);
    else
     $directory=$startDIR;
     parseDir($directory, $disallowed);
    echo '</body>'."\n";
    echo '</html>'."\n";
    exit;
}

//[Begin Functions]//////////////////////////////////////

/* Function: parseDIR
 * @ Param: String $sdir, String $noshow
 * @ Returns: None
 * This function takes a string representation of the file path and parses it for files
 * and folders, displaying them similarly to the manner in which Apache defaults to showing
 * files and such, except that this hides php files and parent directories (. and ..).
 * It also allows for a list of disallowed file extensions (most php variants are the default).
 */
function parseDir($sdir, $noshow="php, php4, php5, phps"){   
    global $filesperpage, $folderslabel, $fileslabel, $maxcolumns;
    /*Take our string and open the resulting directory handle*/
    //$dh=opendir($sdir); //<-old
    /* 4/27/08 JP: Updated to use the linux 'ls' command with some options to 
       list the files in a folder. The reason we use this is to allow for the 
       listing of files with the newest files at the top. */
    //Need to set spaces in dir name to '\ ' because linux commands need it.
    $sdir = str_replace(' ', '\ ', $sdir);
    $x='';
    //Fire off the ls command with options
    exec('ls -atc '.$sdir, $x);
    //Set our dir back the way we had it.
    $sdir = str_replace('\\', '', $sdir);
    /*Read in the entries for the specified directory*/
    //while(($file=readdir($dh))!=false)
    /* 4/27/08 JP: This all works the same way */
    foreach($x as $file)
    {   /*As long as the entry is not ., .., or andthing ending in the $disallowed we should be fine*/
        if($file!="." && $file!=".." && strpos($noshow, substr($file, strrpos($file, ".")+1, strlen($file)))===false)
        {
            if(is_file($sdir.'/'.$file))
              $files[]=$file; //It's a file
            else
              $dirs[]=$sdir.'/'.$file; //It's a folder
        }
    }
    /*Make sure we close the directory*/
    /* 4/27/08 JP: Unused now that we're using linux 'ls'.*/
    //closedir($dh);

    /*If we found any subfolders*/
    if(isset($dirs))
    {
        echo $folderslabel; echo "\n";
        //natcasesort($dirs);
        /*Here, we go to each folder and output a link to that folder. The link is
          actually a reference to the script with an encoded directory entry to keep
          average people from noticing what the script is doing.*/
        echo '<ul>'; echo "\n";
        foreach($dirs as $dir){
           echo '<li><a href="'.$_SERVER['PHP_SELF'].'?SSID='.base64_encode($dir).'">'.substr($dir, strrpos($dir, "/")+1, strlen($dir)).'</a><br>'."\n";
           echo "\n";
        }
        echo '</ul>'; echo "\n";
    }
    echo '<br><a href="'.$_SERVER['PHP_SELF'].'">Top</a></br>'."\n";
    /*If we found any files*/
    if(isset($files))
    {
        echo $fileslabel; echo "\n";
        echo '<table width="50%" cellpadding="2" cellspacing="0" border="0">'."\n";
        //natcasesort($files);
        /*File are handled a little differently. If it's an image file of a typical web format then
          we call this script again, passing in certain parameters. This will cause the script to
          make a thumbnail of the image and return it to the browser. We also link to the original
          image if a larger view is desired.
          Other files basically get a designation placed as to what they are. Several common formats
          are listed and you can add your own case if you have something you want done.*/
        $colcount=0;
        $offset=0;
        if(isset($_REQUEST['offset'])){$offset=$_REQUEST['offset'];}
	$filecount=count($files);
        //foreach($files as $file)
        for($i=0; $i<=$filesperpage; $i++)
        {    //Image files get thumbnails
            if(($i+$offset+1)>$filecount){break;}
            if($colcount==0){echo '<tr>';}
            if(strpos("jpg, JPG, jpeg, JPEG, gif, GIF, png, PNG" ,substr($files[$i+$offset], strrpos($files[$i+$offset], ".")+1, strlen($files[$i+$offset])))!==false){
               echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'"><img src="'.$_SERVER['PHP_SELF'].'?file='.$sdir.'/'.$files[$i+$offset].'&t='.substr($files[$i+$offset], strrpos($files[$i+$offset], ".")+1, strlen($files[$i+$offset])).'" border="0"><br>Image: '.$files[$i+$offset].'</a></td>'."\n";
               $colcount++;
            }
            else //Everyone else just gets a short description.
               switch(substr($files[$i], strrpos($files[$i+$offset], ".")+1, strlen($files[$i+$offset]))){
                   case "mp3":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Music:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   case "wav":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Sound:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   case "avi":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Movie:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   case "mpg":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Movie:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   case "tar":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Archive:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   case "zip":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Archive:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   case "exe":
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">Program:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
                   default:
                       echo '<td><a href="'.$sdir.'/'.$files[$i+$offset].'">File:<br>'.$files[$i+$offset].'</a></td>';
                       echo "\n";
                       $colcount++;
                   break;
               }
               if($colcount==$maxcolumns){echo '</tr>'."\n"; $colcount=0;}
        }
     if($colcount!=$maxcolumns){
      while($colcount!=0 && $colcount<$maxcolumns){
        echo '<td>&nbsp;</td>'."\n";
        $colcount++;
      }
      echo '</tr>'."\n";
     }
     echo '</table>'."\n";
     echo '<hr>'; echo "\n";
     $numpages=round($filecount/$filesperpage, 0);
     $t=0;
     $counter=1;
     for($i=0; $i<$numpages; $i++){
        $counter++;
        if(isset($_REQUEST['SSID'])){
	  $q='&SSID='.$_REQUEST['SSID'];
        }else{
          $q='';
        }
	echo '|<a href="'.$_SERVER['PHP_SELF'].'?offset='.$t.''.$q.'">'.($i+1).'</a>|';
        $t+=$filesperpage+1;
        if($counter==45){
	   echo '<br />'."\n";
           $counter=1;
	}
        
     }
    }
    else{ //Obviously if there are no files, we want to do something besides a blank screen.
     echo 'No files here...<br>'; echo "\n";
     echo '<hr>'; echo "\n";
    }
}

/* Function: sizeImage
 * @ Params: String $file, String $type, Integer $height
 * @ Returns: Binary image data (to the browser)
 * This function takes an image file of a specified type anf makes a thumbnail of
 * the image to the specified height. Right now, the main image formats supported
 * by GD are used. If the function cannot successfully make sense of the file,
 * The script returns an "Error" image to the browser.
 */
function sizeImage($file, $type, $height)
{
    /*We want to take the type that is provided and use that to open the file correctly.*/
    switch(strtolower($type)){
        case "jpg": //If we are given a JPEG typ of file
            header("Content-type: image/jpeg"); //<- Make sure we send the correct header.
            $im=@imagecreatefromjpeg($file);
            /*We try to make a jpeg with the above line. If we are successful...*/
            if($im){
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagecopyresampled($image, $im, 0,0,0,0, imagesx($image), imagesy($image), imagesx($im), imagesy($im));
            //Resize the image using the two lines above and then output it as a jpeg to the browser here.
            imagejpeg($image);
            }
            else
            { //Something is wrong and so we make an error image to let teh user know.
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagefill($image, 0, 0, imagecolorallocate($image, 0, 0, 0));
            imagestring($image, imagesx($image)/4, imagesy($image)/2, 0, "Error!", imagecolorallocate($image, 255, 255, 255));
            imagejpeg($image);
            }
        break;
        case "jpeg": //<- Same as a jpg...but with one extra character in the extension.
            header("Content-type: image/jpeg"); //<- Make sure we send the correct header.
            $im=@imagecreatefromjpeg($file);
            /*We try to make a jpeg with the above line. If we are successful...*/
            if($im){
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagecopyresampled($image, $im, 0,0,0,0, imagesx($image), imagesy($image), imagesx($im), imagesy($im));
            //Resize the image using the two lines above and then output it as a jpeg to the browser here.
            imagejpeg($image);
            }
            else
            { //Something is wrong and so we make an error image to let teh user know.
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagefill($image, 0, 0, imagecolorallocate($image, 0, 0, 0));
            imagestring($image, imagesx($image)/4, imagesy($image)/2, 0, "Error!", imagecolorallocate($image, 255, 255, 255));
            imagejpeg($image);
            }
        break;
        case "gif": //Much like a JPEG, but this case handles GIF89a format
            header("Content-type: image/gif");
            $im=@imagecreatefromgif($file);
            if($im){
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagecopyresampled($image, $im, 0,0,0,0, imagesx($image), imagesy($image), imagesx($im), imagesy($im));
            imagegif($image);
            }
            else
            { //Error
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagefill($image, 0, 0, imagecolorallocate($image, 0, 0, 0));
            imagestring($image, imagesx($image)/4, imagesy($image)/2, 0, "Error!", imagecolorallocate($image, 255, 255, 255));
            imagejpeg($image);
            }
        break;
        case "png": //Probably a better format than GIF89a, PNG (Portable Network Graphic) is handled here
            header("Content-type: image/png");
            $im=@imagecreatefrompng($file);
            if($im){
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagecopyresampled($image, $im, 0,0,0,0, imagesx($image), imagesy($image), imagesx($im), imagesy($im));
            imagepng($image);
            }
            else
            { //Error
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagefill($image, 0, 0, imagecolorallocate($image, 0, 0, 0));
            imagestring($image, imagesx($image)/4, imagesy($image)/2, 0, "Error!", imagecolorallocate($image, 255, 255, 255));
            imagejpeg($image);
            }
        break;
        default: //We don't know what the format is...so we'll pretend it's a JPEG and hope for the best.
            header("Content-type: image/jpeg"); //<- Make sure we send the correct header.
            $im=@imagecreatefromstring(file_get_contents($file));
            /*We try to make a jpeg with the above line. If we are successful...*/
            if($im){
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagecopyresampled($image, $im, 0,0,0,0, imagesx($image), imagesy($image), imagesx($im), imagesy($im));
            //Resize the image using the two lines above and then output it as a jpeg to the browser here.
            imagejpeg($image);
            }
            else
            { //Something is wrong and so we make an error image to let teh user know.
            $image=imagecreatetruecolor(imagesx($im)/(imagesy($im)/$height), $height);
            imagefill($image, 0, 0, imagecolorallocate($image, 0, 0, 0));
            imagestring($image, imagesx($image)/4, imagesy($image)/2, 0, "Error!", imagecolorallocate($image, 255, 255, 255));
            imagejpeg($image);
            }
        break;
    }
    /*The most important part of this is to destroy any in-memory images so that
      system resources are preserved and we don't crash the server.*/
    if(isset($im))
        imagedestroy($im);
    if(isset($image))
        imagedestroy($image);
}
?>
